#version 330 core

uniform float deltaTime;
uniform vec2  direction;
uniform sampler2D noise;

/*
float rand(in vec2 co)
{
        return 0.5 + (fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453))*0.5;
}
*/

in vec4 POSITION;
//in vec4 COLOR;

//out vec4 gs_color;

void main()
{
	float scale = smoothstep(0.1, 0.3, 1.0 - POSITION.w) * 12.0 * deltaTime;
	vec3 n = normalize(POSITION.xyz);
	vec3 pos = POSITION.xyz*0.008;
	vec4 offset = textureLod(noise, pos.xz + vec2(pos.y+0.01), 0.0).rbga*2.0 - vec4(1.0);
#if 0
	offset.x += 0.5;
	offset.z -= 0.5;
#else
	//offset.x += 0.5;
	//offset.z += 0.5;
	offset.x += direction.x;
	offset.z += direction.y;
#endif
	offset.x *= scale;
	offset.y = (offset.y + 0.4)*1.0*deltaTime;
	offset.z *= scale;
	offset.w = -(1.0/32.0)*deltaTime;

	//gs_color = COLOR;
	gl_Position = POSITION + offset;
}
